/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.util.Enumeration;
import java.util.Hashtable;
import oracle.cluster.verification.StorageSize;
import oracle.cluster.verification.VerificationException;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.report.ReportUtil;

public abstract class PeerCompatibleTask
extends Task {
    public abstract ResultSet performPeer() throws VerificationException;

    public ResultSet performPeer(String refNode) throws VerificationException {
        ResultSet resultSet = this.performPeer();
        Hashtable ht = resultSet.getResultTable();
        Result refNodeResult = (Result)ht.get(refNode);
        Object refNodeValue = null;
        int refNodeStatus = refNodeResult.getStatus();
        if (refNodeResult.getResultInfoSet().size() > 0) {
            refNodeValue = refNodeResult.getResultInfoSet().elementAt(0);
        }
        Object nodeValue = null;
        Enumeration e = ht.keys();
        while (e.hasMoreElements()) {
            String node = (String)e.nextElement();
            Result result = (Result)ht.get(node);
            if (node.equals(refNode)) {
                result.setStatus(1);
                resultSet.setStatus();
                continue;
            }
            if (result.getResultInfoSet().size() > 0) {
                nodeValue = result.getResultInfoSet().elementAt(0);
            }
            if (result.getStatus() == 1) {
                if (this.matchesRefrenceNode(nodeValue, refNodeValue)) continue;
                result.setStatus(3);
                resultSet.setStatus();
                continue;
            }
            if (result.getStatus() != 3 || refNodeStatus != result.getStatus()) continue;
            result.setStatus(1);
            resultSet.setStatus();
        }
        return resultSet;
    }

    protected boolean matchesRefrenceNode(Object nodeValue, Object referenceNodeValue) {
        if (nodeValue == referenceNodeValue) {
            return true;
        }
        if (nodeValue == null) {
            return false;
        }
        return nodeValue.toString().equals(String.valueOf(referenceNodeValue));
    }

    protected String formatValue(Object nodeValue) {
        if (nodeValue instanceof StorageSize) {
            return ReportUtil.unitizeSize((StorageSize)nodeValue);
        }
        return nodeValue.toString();
    }

    public abstract String getElementDisplayName();
}

